"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var VideoShapeUtil_exports = {};
__export(VideoShapeUtil_exports, {
  VideoShapeUtil: () => VideoShapeUtil
});
module.exports = __toCommonJS(VideoShapeUtil_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_react = require("react");
var import_BrokenAssetIcon = require("../shared/BrokenAssetIcon");
var import_HyperlinkButton = require("../shared/HyperlinkButton");
var import_useAsset = require("../shared/useAsset");
var import_usePrefersReducedMotion = require("../shared/usePrefersReducedMotion");
class VideoShapeUtil extends import_editor.BaseBoxShapeUtil {
  static type = "video";
  static props = import_editor.videoShapeProps;
  static migrations = import_editor.videoShapeMigrations;
  canEdit = () => true;
  isAspectRatioLocked = () => true;
  getDefaultProps() {
    return {
      w: 100,
      h: 100,
      assetId: null,
      time: 0,
      playing: true,
      url: ""
    };
  }
  component(shape) {
    const { editor } = this;
    const showControls = editor.getShapeGeometry(shape).bounds.w * editor.getZoomLevel() >= 110;
    const { asset, url } = (0, import_useAsset.useAsset)(shape.id, shape.props.assetId, shape.props.w);
    const { time, playing } = shape.props;
    const isEditing = (0, import_editor.useIsEditing)(shape.id);
    const prefersReducedMotion = (0, import_usePrefersReducedMotion.usePrefersReducedMotion)();
    const rVideo = (0, import_react.useRef)(null);
    const handlePlay = (0, import_react.useCallback)(
      (e) => {
        const video = e.currentTarget;
        if (!video) return;
        editor.updateShapes([
          {
            type: "video",
            id: shape.id,
            props: {
              playing: true,
              time: video.currentTime
            }
          }
        ]);
      },
      [shape.id, editor]
    );
    const handlePause = (0, import_react.useCallback)(
      (e) => {
        const video = e.currentTarget;
        if (!video) return;
        editor.updateShapes([
          {
            type: "video",
            id: shape.id,
            props: {
              playing: false,
              time: video.currentTime
            }
          }
        ]);
      },
      [shape.id, editor]
    );
    const handleSetCurrentTime = (0, import_react.useCallback)(
      (e) => {
        const video = e.currentTarget;
        if (!video) return;
        if (isEditing) {
          editor.updateShapes([
            {
              type: "video",
              id: shape.id,
              props: {
                time: video.currentTime
              }
            }
          ]);
        }
      },
      [isEditing, shape.id, editor]
    );
    const [isLoaded, setIsLoaded] = (0, import_react.useState)(false);
    const handleLoadedData = (0, import_react.useCallback)(
      (e) => {
        const video = e.currentTarget;
        if (!video) return;
        if (time !== video.currentTime) {
          video.currentTime = time;
        }
        if (!playing) {
          video.pause();
        }
        setIsLoaded(true);
      },
      [playing, time]
    );
    (0, import_react.useEffect)(() => {
      const video = rVideo.current;
      if (!video) return;
      if (isLoaded && !isEditing && time !== video.currentTime) {
        video.currentTime = time;
      }
      if (isEditing) {
        if (document.activeElement !== video) {
          video.focus();
        }
      }
    }, [isEditing, isLoaded, time]);
    (0, import_react.useEffect)(() => {
      if (prefersReducedMotion) {
        const video = rVideo.current;
        if (!video) return;
        video.pause();
        video.currentTime = 0;
      }
    }, [rVideo, prefersReducedMotion]);
    return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_jsx_runtime.Fragment, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        import_editor.HTMLContainer,
        {
          id: shape.id,
          style: {
            color: "var(--color-text-3)",
            backgroundColor: asset ? "transparent" : "var(--color-low)",
            border: asset ? "none" : "1px solid var(--color-low-border)"
          },
          children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tl-counter-scaled", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tl-video-container", children: !asset?.props.src ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_BrokenAssetIcon.BrokenAssetIcon, {}) : url ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
            "video",
            {
              ref: rVideo,
              style: isEditing ? { pointerEvents: "all" } : void 0,
              className: `tl-video tl-video-shape-${shape.id.split(":")[1]}`,
              width: "100%",
              height: "100%",
              draggable: false,
              playsInline: true,
              autoPlay: true,
              muted: true,
              loop: true,
              disableRemotePlayback: true,
              disablePictureInPicture: true,
              controls: isEditing && showControls,
              onPlay: handlePlay,
              onPause: handlePause,
              onTimeUpdate: handleSetCurrentTime,
              onLoadedData: handleLoadedData,
              hidden: !isLoaded,
              children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("source", { src: url })
            }
          ) : null }) })
        }
      ),
      "url" in shape.props && shape.props.url && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_HyperlinkButton.HyperlinkButton, { url: shape.props.url, zoomLevel: editor.getZoomLevel() })
    ] });
  }
  indicator(shape) {
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("rect", { width: (0, import_editor.toDomPrecision)(shape.props.w), height: (0, import_editor.toDomPrecision)(shape.props.h) });
  }
  toSvg(shape) {
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("image", { href: serializeVideo(shape.id), width: shape.props.w, height: shape.props.h });
  }
}
function serializeVideo(id) {
  const splitId = id.split(":")[1];
  const video = document.querySelector(`.tl-video-shape-${splitId}`);
  if (video) {
    const canvas = document.createElement("canvas");
    canvas.width = video.videoWidth;
    canvas.height = video.videoHeight;
    canvas.getContext("2d").drawImage(video, 0, 0);
    return canvas.toDataURL("image/png");
  } else throw new Error("Video with not found when attempting serialization.");
}
//# sourceMappingURL=VideoShapeUtil.js.map
